<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Авторизация';
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Html::encode($this->title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #222222;
            --secondary: #393939;
            --accent: #fd79a8;
            --dark: #2d3436;
            --light: #dfe6e9;
            --success: #00b894;
            --gradient: linear-gradient(135deg, #424242 0%, #232323 100%);
        }

        body {

            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-container {
            max-width: 650px;
            width: 100%;
        }

        .login-card {
            background: #fbfbfb;
            border-radius: 25px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
            overflow: hidden;
            transform: translateY(0);
            transition: all 0.4s ease;
            position: relative;
        }

        .login-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 30px 50px rgba(0, 0, 0, 0.2);
        }

        .login-header {
            background: var(--gradient);
            color: white;
            padding: 40px 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .login-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255,255,255,0.1), transparent);
            transform: rotate(45deg);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
            100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
        }

        .header-icon {
            font-size: 3rem;
            margin-bottom: 15px;
            display: block;
            animation: float 3s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        .login-header h1 {
            margin: 0;
            font-weight: 800;
            font-size: 2.2rem;
            position: relative;
            z-index: 2;
        }

        .login-header p {
            margin: 10px 0 0 0;
            opacity: 0.9;
            font-size: 1.1rem;
            position: relative;
            z-index: 2;
        }

        .login-body {
            padding: 40px;
        }

        .form-group {
            margin-bottom: 25px;
            position: relative;
        }

        .form-label {
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            font-size: 1.1rem;
        }

        .form-label i {
            margin-right: 12px;
            color: black;
            font-size: 1.2rem;
            width: 20px;
            text-align: center;
        }

        .form-control {
            border: 3px solid #f1f3f4;
            border-radius: 15px;
            padding: 15px 20px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #fafbfc;
            font-weight: 500;
        }

        .form-control:focus {
            border-color: black;
            box-shadow: 0 0 0 0.3rem rgba(202, 202, 202, 0.15);
            background: white;
            transform: translateY(-2px);
        }

        .form-control::placeholder {
            color: #a0a0a0;
            font-weight: 400;
        }

        .btn-login {
            background: black;
            color: white;
            border: none;
            border-radius: 50px;
            padding: 18px 50px;
            font-weight: 700;
            font-size: 1.2rem;
            transition: all 0.4s ease;
            box-shadow: 0 10px 25px rgba(90, 90, 90, 0.2);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            position: relative;
            overflow: hidden;
        }

        .btn-login::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s;
        }

        .btn-login:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(55, 55, 55, 0.6);
            color: #292929;
        }

        .btn-login:hover::before {
            left: 100%;
        }

        .btn-login i {
            margin-right: 12px;
            font-size: 1.3rem;
        }

        .register-link {
            text-align: center;
            margin-top: 25px;
            padding-top: 25px;
            border-top: 2px solid #f1f3f4;
        }

        .register-link a {
            color: gray;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .register-link a:hover {
            color: gray;
            transform: translateX(5px);
        }

        .field-hint {
            font-size: 13px;
            color: gray;
            margin-top: 8px;
            display: flex;
            align-items: center;
            padding-left: 32px;
        }

        .field-hint i {
            margin-right: 6px;
            font-size: 12px;
        }

        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #a0a0a0;
            cursor: pointer;
            transition: color 0.3s ease;
            z-index: 2;
        }

        .password-toggle:hover {
            color: var(--primary);
        }

        .floating-elements {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
            z-index: 1;
        }

        .floating-element {
            position: absolute;
            background: rgba(28, 28, 28, 0.1);
            border-radius: 50%;
            animation: float-random 6s ease-in-out infinite;
        }

        .floating-element:nth-child(1) {
            width: 20px;
            height: 20px;
            top: 20%;
            left: 10%;
            animation-delay: 0s;
        }

        .floating-element:nth-child(2) {
            width: 15px;
            height: 15px;
            top: 60%;
            left: 80%;
            animation-delay: 2s;
        }

        .floating-element:nth-child(3) {
            width: 25px;
            height: 25px;
            top: 80%;
            left: 20%;
            animation-delay: 4s;
        }

        @keyframes float-random {
            0%, 100% { transform: translateY(0) translateX(0); }
            25% { transform: translateY(-20px) translateX(10px); }
            50% { transform: translateY(-10px) translateX(-10px); }
            75% { transform: translateY(10px) translateX(15px); }
        }

        .remember-forgot {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 8px;
            color: var(--dark);
            font-weight: 500;
        }

        .remember-me input[type="checkbox"] {
            width: 18px;
            height: 18px;
            accent-color: var(--primary);
        }

        .forgot-password {
            color: var(--primary);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
        }

        .forgot-password:hover {
            color: var(--secondary);
        }

        @media (max-width: 768px) {
            .login-body {
                padding: 30px 20px;
            }

            .login-header {
                padding: 30px 20px;
            }

            .login-header h1 {
                font-size: 1.8rem;
            }

            .btn-login {
                padding: 15px 30px;
                font-size: 1.1rem;
            }

            .remember-forgot {
                flex-direction: column;
                gap: 15px;
                align-items: flex-start;
            }
        }
    </style>
</head>
<body>
<div class="login-container">
    <div class="login-card">
        <div class="floating-elements">
            <div class="floating-element"></div>
            <div class="floating-element"></div>
            <div class="floating-element"></div>
        </div>

        <div class="login-header">
<!--            <i class="header-icon fas fa-sign-in-alt"></i>-->
            <h1><?= Html::encode($this->title) ?></h1>
            <p>Войдите в ваш аккаунт</p>
        </div>

        <div class="login-body">
            <?php $form = ActiveForm::begin([
                'options' => ['class' => 'login-form'],
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'form-label'],
                    'inputOptions' => ['class' => 'form-control'],
                    'errorOptions' => ['class' => 'help-block text-danger mt-2']
                ]
            ]); ?>

            <div class="form-group">
                <?= $form->field($model, 'email')->textInput([
                    'placeholder' => 'your@email.com'
                ])->label('<i class="fas fa-envelope"></i> Email') ?>
                <div class="field-hint">
                    <i class="fas fa-info-circle"></i> Введите ваш email для входа
                </div>
            </div>

            <div class="form-group" style="position: relative;">
                <?= $form->field($model, 'password')->passwordInput([
                    'placeholder' => 'Введите ваш пароль',
                    'id' => 'password-field'
                ])->label('<i class="fas fa-lock"></i> Пароль') ?>
                <button type="button" class="password-toggle" id="password-toggle">
                    <i class="fas fa-eye"></i>
                </button>
                <div class="field-hint">
                    <i class="fas fa-info-circle"></i> Введите ваш пароль
                </div>
            </div>



            <div class="form-group">
                <?= Html::submitButton('<i class="fas fa-sign-in-alt"></i> Войти', [
                    'class' => 'btn btn-login',
                    'data-loading-text' => '<i class="fas fa-spinner fa-spin"></i> Вход...'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>


        </div>
    </div>
</div>

<!--<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>-->
<!--<script>-->
<!--    // Анимация кнопки при отправке-->
<!--    document.querySelector('.login-form').addEventListener('submit', function(e) {-->
<!--        const btn = this.querySelector('.btn-login');-->
<!--        const originalText = btn.innerHTML;-->
<!--        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Вход...';-->
<!--        btn.disabled = true;-->
<!---->
<!--        // В реальном приложении здесь будет AJAX запрос-->
<!--        setTimeout(() => {-->
<!--            btn.innerHTML = originalText;-->
<!--            btn.disabled = false;-->
<!--        }, 3000);-->
<!--    });-->
<!---->
<!--    // Toggle password visibility-->
<!--    const passwordToggle = document.getElementById('password-toggle');-->
<!--    const passwordField = document.getElementById('password-field');-->
<!---->
<!--    passwordToggle.addEventListener('click', function() {-->
<!--        const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';-->
<!--        passwordField.setAttribute('type', type);-->
<!---->
<!--        // Toggle eye icon-->
<!--        const icon = this.querySelector('i');-->
<!--        if (type === 'text') {-->
<!--            icon.classList.remove('fa-eye');-->
<!--            icon.classList.add('fa-eye-slash');-->
<!--        } else {-->
<!--            icon.classList.remove('fa-eye-slash');-->
<!--            icon.classList.add('fa-eye');-->
<!--        }-->
<!--    });-->
<!---->
<!--    // Анимация появления полей-->
<!--    const formGroups = document.querySelectorAll('.form-group');-->
<!--    formGroups.forEach((group, index) => {-->
<!--        group.style.opacity = '0';-->
<!--        group.style.transform = 'translateY(20px)';-->
<!---->
<!--        setTimeout(() => {-->
<!--            group.style.transition = 'all 0.6s ease';-->
<!--            group.style.opacity = '1';-->
<!--            group.style.transform = 'translateY(0)';-->
<!--        }, index * 200);-->
<!--    });-->
<!---->
<!--    // Focus effect for inputs-->
<!--    const inputs = document.querySelectorAll('.form-control');-->
<!--    inputs.forEach(input => {-->
<!--        input.addEventListener('focus', function() {-->
<!--            this.parentElement.classList.add('focused');-->
<!--        });-->
<!---->
<!--        input.addEventListener('blur', function() {-->
<!--            if (!this.value) {-->
<!--                this.parentElement.classList.remove('focused');-->
<!--            }-->
<!--        });-->
<!--    });-->
<!--</script>-->
</body>
</html>