<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'HR System - Управление персоналом';
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Html::encode($this->title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #1e1e1e;
            --secondary: #a29bfe;
            --accent: #fd79a8;
            --dark: #2d3436;
            --light: #dfe6e9;
            --success: #00b894;
            --gradient1: linear-gradient(135deg, #4facfe 0%, #0059fe 100%);
            --gradient2: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --gradient3: linear-gradient(135deg, #272727 0%, #373737 100%);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;

            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Hero Section */
        .hero-section {
            background: var(--gradient);
            color: white;
            min-height: 100vh;
            display: flex;
            align-items: center;
            position: relative;
            overflow: hidden;
        }

        .hero-bg {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0.1;
        }

        .hero-content {
            position: relative;
            z-index: 2;
            padding: 100px 0;
        }

        .hero-title {
            font-size: 4rem;
            font-weight: 800;
            margin-bottom: 1.5rem;
            line-height: 1.1;
        }

        .hero-subtitle {
            font-size: 1.5rem;
            margin-bottom: 2rem;
            opacity: 0.9;
            font-weight: 300;
        }

        .hero-buttons {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
        }

        .btn-hero {
            padding: 15px 40px;
            border-radius: 50px;
            font-weight: 600;
            font-size: 1.1rem;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 10px;
        }

        .btn-primary-hero {
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            color: white;
            border: 2px solid rgba(255, 255, 255, 0.3);
        }

        .btn-primary-hero:hover {
            background: #252525;
            color: var(--primary);
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .btn-secondary-hero {
            background: white;
            color: var(--primary);
            border: 2px solid white;
        }

        .btn-secondary-hero:hover {
            background: transparent;
            color: white;
            transform: translateY(-3px);
        }

        .floating-shapes {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
        }

        .shape {
            position: absolute;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            animation: float 6s ease-in-out infinite;
        }

        .shape1 { width: 100px; height: 100px; top: 20%; left: 10%; animation-delay: 0s; }
        .shape2 { width: 150px; height: 150px; top: 60%; left: 80%; animation-delay: 2s; }
        .shape3 { width: 80px; height: 80px; top: 80%; left: 20%; animation-delay: 4s; }
        .shape4 { width: 120px; height: 120px; top: 40%; left: 85%; animation-delay: 1s; }

        @keyframes float {
            0%, 100% { transform: translateY(0) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }

        /* Features Section */
        .features-section {
            padding: 20px 0;

        }

        .section-title {
            text-align: center;
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 3rem;
            background: var(--gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 50px;
        }

        .feature-card {
            background: #222222;
            padding: 40px 30px;
            border-radius: 20px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            border: 1px solid #f1f3f4;
            position: relative;
            overflow: hidden;
        }

        .feature-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: var(--gradient);
        }

        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        .feature-icon {
            width: 80px;
            height: 80px;
            background: var(--gradient);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
            font-size: 2rem;
            color: white;
        }

        .feature-title {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 15px;
            color: #e1e1e1;
        }

        .feature-description {
            color: #9f9f9f;
            line-height: 1.6;
        }

        /* Stats Section */
        .stats-section {
            padding: 80px 0;
            background: var(--gradient2);
            color: white;
            position: relative;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 30px;
            text-align: center;
        }

        .stat-item {
            padding: 30px;
        }

        .stat-number {
            font-size: 3rem;
            font-weight: 800;
            margin-bottom: 10px;
        }

        .stat-label {
            font-size: 1.1rem;
            opacity: 0.9;
        }

        /* CTA Section */
        .cta-section {
            padding: 100px 0;
            background: var(--gradient3);
            color: white;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .cta-title {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }

        .cta-subtitle {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }

        .btn-cta {
            background: white;
            color: var(--primary);
            padding: 15px 40px;
            border-radius: 50px;
            font-weight: 600;
            font-size: 1.1rem;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            border: 2px solid white;
        }

        .btn-cta:hover {
            background: transparent;
            color: white;
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        /* Footer */
        .footer {
            background: var(--dark);
            color: white;
            padding: 50px 0 20px;
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-bottom: 40px;
        }

        .footer-section h3 {
            margin-bottom: 20px;
            color: var(--secondary);
        }

        .footer-links {
            list-style: none;
        }

        .footer-links li {
            margin-bottom: 10px;
        }

        .footer-links a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer-links a:hover {
            color: var(--secondary);
        }

        .footer-bottom {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid #444;
            color: #999;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }

            .hero-subtitle {
                font-size: 1.2rem;
            }

            .section-title {
                font-size: 2rem;
            }

            .hero-buttons {
                flex-direction: column;
                align-items: flex-start;
            }

            .btn-hero {
                width: 100%;
                justify-content: center;
            }

            .cta-title {
                font-size: 2rem;
            }
        }

        /* Navigation */
        .navbar {
            position: fixed;
            top: 0;
            width: 100%;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            z-index: 1000;
            padding: 15px 0;
            transition: all 0.3s ease;
        }

        .navbar.scrolled {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
        }

        .nav-brand {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary);
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            gap: 30px;
            list-style: none;
            margin: 0;
        }

        .nav-links a {
            color: var(--dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
        }

        .nav-links a:hover {
            color: var(--primary);
        }
    </style>
</head>
<body>
<!-- Navigation -->


<!-- Hero Section -->
<section class="hero-section">
    <div class="floating-shapes">
        <div class="shape shape1"></div>
        <div class="shape shape2"></div>
        <div class="shape shape3"></div>
        <div class="shape shape4"></div>
    </div>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-10">
                <div class="hero-content">
                    <h1 class="hero-title">
                        Управление персоналом
                        <span style="display: block; color: #fd79a8;">с умом</span>
                    </h1>
                    <p class="hero-subtitle">
                        Современная система для управления сотрудниками, анкетами и HR-процессами.
                        Эффективно, удобно, безопасно.
                    </p>
                    <div class="hero-buttons">
                        <a href="<?= Url::to(['/site/login']) ?>" class="btn-hero btn-primary-hero">
                            <i class="fas fa-rocket"></i> Начать работу
                        </a>
                        <a href="#features" class="btn-hero btn-secondary-hero">
                            <i class="fas fa-play-circle"></i> Узнать больше
                        </a>
                    </div>
                </div>
            </div>
<!--            <div class="col-lg-6">-->
<!--                <div class="text-center">-->
<!--                    <img src="https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80"-->
<!--                         alt="HR Management" class="img-fluid rounded-3 shadow-lg"-->
<!--                         style="max-height: 500px; object-fit: cover;">-->
<!--                </div>-->
<!--            </div>-->
        </div>
    </div>
</section>

<!-- Features Section -->
<section id="features" class="features-section">
    <div class="container">
        <h2 class="section-title">Наши возможности</h2>
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-user-tie"></i>
                </div>
                <h3 class="feature-title">Управление анкетами</h3>
                <p class="feature-description">
                    Создание, редактирование и управление анкетами сотрудников.
                    Все данные в одном месте.
                </p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-chart-line"></i>
                </div>
                <h3 class="feature-title">Аналитика и отчеты</h3>
                <p class="feature-description">
                    Детальная аналитика по сотрудникам, стажу, образованию
                    и другим параметрам.
                </p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <h3 class="feature-title">Безопасность данных</h3>
                <p class="feature-description">
                    Надежная защита персональных данных сотрудников
                    в соответствии с законодательством.
                </p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-cogs"></i>
                </div>
                <h3 class="feature-title">Автоматизация процессов</h3>
                <p class="feature-description">
                    Автоматизация рутинных HR-процессов, уведомления
                    и напоминания.
                </p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-mobile-alt"></i>
                </div>
                <h3 class="feature-title">Мобильный доступ</h3>
                <p class="feature-description">
                    Доступ к системе с любого устройства.
                    Работайте где угодно и когда угодно.
                </p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-headset"></i>
                </div>
                <h3 class="feature-title">Поддержка 24/7</h3>
                <p class="feature-description">
                    Круглосуточная техническая поддержка
                    и консультации по работе с системой.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<!--<section id="stats" class="stats-section">-->
<!--    <div class="container">-->
<!--        <div class="stats-grid">-->
<!--            <div class="stat-item">-->
<!--                <div class="stat-number">500+</div>-->
<!--                <div class="stat-label">Компаний доверяют</div>-->
<!--            </div>-->
<!--            <div class="stat-item">-->
<!--                <div class="stat-number">50K+</div>-->
<!--                <div class="stat-label">Анкет обработано</div>-->
<!--            </div>-->
<!--            <div class="stat-item">-->
<!--                <div class="stat-number">99.9%</div>-->
<!--                <div class="stat-label">Надежность системы</div>-->
<!--            </div>-->
<!--            <div class="stat-item">-->
<!--                <div class="stat-number">24/7</div>-->
<!--                <div class="stat-label">Техподдержка</div>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->

<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <h2 class="cta-title">Готовы начать работу?</h2>
        <p class="cta-subtitle">
            Присоединяйтесь к тысячам компаний, которые уже используют нашу систему
        </p>
        <a href="<?= Url::to(['/site/signup']) ?>" class="btn-cta">
            <i class="fas fa-rocket"></i> Начать бесплатно
        </a>
    </div>
</section>



<script>
    // Navbar scroll effect
    window.addEventListener('scroll', function() {
        const navbar = document.querySelector('.navbar');
        if (window.scrollY > 100) {
            navbar.classList.add('scrolled');
        } else {
            navbar.classList.remove('scrolled');
        }
    });

    // Smooth scrolling
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
</script>
</body>
</html>