<?php
/** @var yii\web\View $this */
/** @var app\models\Profile $model */

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Анкета сотрудника';
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Html::encode($this->title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #222222;
            --secondary: #393939;
            --accent: #fd79a8;
            --dark: #2d3436;
            --light: #dfe6e9;
            --success: #00b894;
            --gradient: linear-gradient(135deg, #424242 0%, #232323 100%);
        }

        body {

            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .anketa-container {
            max-width: 600px;
            width: 100%;
        }

        .anketa-card {
            background: white;
            border-radius: 25px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
            overflow: hidden;
            transform: translateY(0);
            transition: all 0.4s ease;
        }

        .anketa-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 30px 50px rgba(0, 0, 0, 0.2);
        }

        .anketa-header {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: white;
            padding: 40px 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .anketa-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255,255,255,0.1), transparent);
            transform: rotate(45deg);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
            100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
        }

        .header-icon {
            font-size: 3rem;
            margin-bottom: 15px;
            display: block;
            animation: float 3s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        .anketa-header h1 {
            margin: 0;
            font-weight: 800;
            font-size: 2.2rem;
            position: relative;
            z-index: 2;
        }

        .anketa-header p {
            margin: 10px 0 0 0;
            opacity: 0.9;
            font-size: 1.1rem;
            position: relative;
            z-index: 2;
        }

        .anketa-body {
            padding: 40px;
        }

        .form-group {
            margin-bottom: 30px;
            position: relative;
        }

        .form-label {
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            font-size: 1.1rem;
        }

        .form-label i {
            margin-right: 12px;
            color: var(--primary);
            font-size: 1.2rem;
            width: 20px;
            text-align: center;
        }

        .form-control {
            border: 3px solid #f1f3f4;
            border-radius: 15px;
            padding: 15px 20px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #fafbfc;
            font-weight: 500;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.3rem rgba(101, 101, 101, 0.15);
            background: white;
            transform: translateY(-2px);
        }

        .form-control::placeholder {
            color: #a0a0a0;
            font-weight: 400;
        }

        .btn-anketa {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: white;
            border: none;
            border-radius: 50px;
            padding: 18px 50px;
            font-weight: 700;
            font-size: 1.2rem;
            transition: all 0.4s ease;
            box-shadow: 0 10px 25px rgba(103, 103, 103, 0.4);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            position: relative;
            overflow: hidden;
        }

        .btn-anketa::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s;
        }

        .btn-anketa:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(115, 115, 115, 0.6);
            color: white;
        }

        .btn-anketa:hover::before {
            left: 100%;
        }

        .btn-anketa i {
            margin-right: 12px;
            font-size: 1.3rem;
        }

        .form-actions {
            margin-top: 40px;
            text-align: center;
        }

        .field-hint {
            font-size: 13px;
            color: var(--primary);
            margin-top: 8px;
            display: flex;
            align-items: center;
            padding-left: 32px;
        }

        .field-hint i {
            margin-right: 6px;
            font-size: 12px;
        }

        .floating-elements {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
            z-index: 1;
        }

        .floating-element {
            position: absolute;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            animation: float-random 6s ease-in-out infinite;
        }

        .floating-element:nth-child(1) {
            width: 20px;
            height: 20px;
            top: 20%;
            left: 10%;
            animation-delay: 0s;
        }

        .floating-element:nth-child(2) {
            width: 15px;
            height: 15px;
            top: 60%;
            left: 80%;
            animation-delay: 2s;
        }

        .floating-element:nth-child(3) {
            width: 25px;
            height: 25px;
            top: 80%;
            left: 20%;
            animation-delay: 4s;
        }

        @keyframes float-random {
            0%, 100% { transform: translateY(0) translateX(0); }
            25% { transform: translateY(-20px) translateX(10px); }
            50% { transform: translateY(-10px) translateX(-10px); }
            75% { transform: translateY(10px) translateX(15px); }
        }

        @media (max-width: 768px) {
            .anketa-body {
                padding: 30px 20px;
            }

            .anketa-header {
                padding: 30px 20px;
            }

            .anketa-header h1 {
                font-size: 1.8rem;
            }

            .btn-anketa {
                padding: 15px 30px;
                font-size: 1.1rem;
            }
        }
    </style>
</head>
<body>
<div class="anketa-container">
    <div class="anketa-card">
        <div class="floating-elements">
            <div class="floating-element"></div>
            <div class="floating-element"></div>
            <div class="floating-element"></div>
        </div>

        <div class="anketa-header">
<!--            <i class="header-icon fas fa-user-tie"></i>-->
            <h1><?= Html::encode($this->title) ?></h1>
            <p>Заполните данные для системы</p>
        </div>

        <div class="anketa-body">
            <?php $form = ActiveForm::begin([
                'options' => [
                    'enctype' => 'multipart/form-data',
                    'class' => 'anketa-form'
                ],
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'form-label'],
                    'inputOptions' => ['class' => 'form-control'],
                    'errorOptions' => ['class' => 'help-block text-danger mt-2']
                ]
            ]); ?>

            <div class="form-group">
                <?= $form->field($model, 'address')->textInput([
                    'maxlength' => true,
                    'placeholder' => 'Введите ваш адрес проживания'
                ])->label('<i class="fas fa-home"></i> Адрес проживания') ?>
                <div class="field-hint">
                    <i class="fas fa-info-circle"></i> Укажите ваш текущий адрес
                </div>
            </div>

            <div class="form-group">
                <?= $form->field($model, 'birth_date')->input('date')->label('<i class="fas fa-birthday-cake"></i> Дата рождения') ?>
                <div class="field-hint">
                    <i class="fas fa-info-circle"></i> Выберите вашу дату рождения
                </div>
            </div>

            <div class="form-group">
                <?= $form->field($model, 'additional_info')->textInput([
                    'placeholder' => 'Дополнительная информация о себе'
                ])->label('<i class="fas fa-info-circle"></i> Дополнительная информация') ?>
                <div class="field-hint">
                    <i class="fas fa-info-circle"></i> Любая дополнительная информация
                </div>
            </div>

            <div class="form-actions">
                <?= Html::submitButton(' Отправить', [
                    'class' => 'btn btn-anketa',
                    'data-loading-text' => '<i class="fas fa-spinner fa-spin"></i> Отправка...'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Анимация кнопки при отправке
    document.querySelector('.anketa-form').addEventListener('submit', function(e) {
        const btn = this.querySelector('.btn-anketa');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Отправка...';
        btn.disabled = true;

        // В реальном приложении здесь будет AJAX запрос
        setTimeout(() => {
            btn.innerHTML = originalText;
            btn.disabled = false;
        }, 3000);
    });

    // Анимация появления полей
    const formGroups = document.querySelectorAll('.form-group');
    formGroups.forEach((group, index) => {
        group.style.opacity = '0';
        group.style.transform = 'translateY(20px)';

        setTimeout(() => {
            group.style.transition = 'all 0.6s ease';
            group.style.opacity = '1';
            group.style.transform = 'translateY(0)';
        }, index * 200);
    });
</script>