<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Редактирование профиля';
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Html::encode($this->title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #6c5ce7;
            --secondary: #a29bfe;
            --accent: #fd79a8;
            --dark: #2d3436;
            --light: #dfe6e9;
            --success: #00b894;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px 0;
        }

        .form-container {
            max-width: 1000px;
            margin: 0 auto;
        }

        .form-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            margin-bottom: 30px;
        }

        .form-header {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .form-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: rgba(255, 255, 255, 0.1);
            transform: rotate(45deg);
        }

        .form-header h1 {
            margin: 0;
            font-weight: 700;
            position: relative;
            z-index: 1;
        }

        .form-header p {
            margin: 10px 0 0 0;
            opacity: 0.9;
            position: relative;
            z-index: 1;
        }

        .form-body {
            padding: 40px;
        }

        .form-section {
            margin-bottom: 40px;
            padding-bottom: 30px;
            border-bottom: 2px solid #f8f9fa;
        }

        .section-title {
            color: var(--primary);
            font-weight: 600;
            margin-bottom: 25px;
            padding-bottom: 10px;
            border-bottom: 2px solid var(--secondary);
            display: flex;
            align-items: center;
        }

        .section-title i {
            margin-right: 10px;
            font-size: 1.2em;
        }

        .form-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .control-label {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 8px;
            display: flex;
            align-items: center;
        }

        .control-label i {
            margin-right: 8px;
            color: var(--primary);
            width: 16px;
        }

        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 12px 15px;
            font-size: 15px;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.2rem rgba(108, 92, 231, 0.25);
            background: white;
        }

        .form-control-file {
            padding: 10px;
            border: 2px dashed #dee2e6;
            border-radius: 12px;
            background: #f8f9fa;
            transition: all 0.3s ease;
        }

        .form-control-file:focus {
            border-color: var(--primary);
            border-style: solid;
        }

        .help-block {
            font-size: 12px;
            color: #6c757d;
            margin-top: 5px;
        }

        .btn-vibe {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: white;
            border: none;
            border-radius: 50px;
            padding: 15px 40px;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(108, 92, 231, 0.4);
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .btn-vibe:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(108, 92, 231, 0.6);
            color: white;
        }

        .btn-vibe i {
            margin-right: 8px;
        }

        .form-actions {
            text-align: center;
            margin-top: 40px;
            padding-top: 30px;
            border-top: 2px solid #f8f9fa;
        }

        .file-hint {
            font-size: 12px;
            color: var(--primary);
            margin-top: 5px;
            display: flex;
            align-items: center;
        }

        .file-hint i {
            margin-right: 5px;
        }

        @media (max-width: 768px) {
            .form-grid {
                grid-template-columns: 1fr;
            }

            .form-body {
                padding: 20px;
            }

            .form-header {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
<div class="form-container">
    <div class="form-card">
        <div class="form-header">
            <h1><i class="fas fa-user-edit"></i> <?= Html::encode($this->title) ?></h1>
            <p>Обновите ваши личные данные</p>
        </div>

        <div class="form-body">
            <?php $form = ActiveForm::begin([
                'options' => [
                    'enctype' => 'multipart/form-data',
                    'class' => 'vibe-form'
                ],
                'fieldConfig' => [
                    'template' => "{label}\n{input}\n{error}",
                    'labelOptions' => ['class' => 'control-label'],
                    'inputOptions' => ['class' => 'form-control'],
                    'errorOptions' => ['class' => 'help-block']
                ]
            ]); ?>

            <div class="form-section">
                <h3 class="section-title"><i class="fas fa-user-circle"></i> Основная информация</h3>
                <div class="form-grid">
                    <?= $form->field($model, 'address')->textInput(['maxlength' => true])->label('<i class="fas fa-home"></i> Адрес') ?>
                    <?= $form->field($model, 'birth_date')->input('date')->label('<i class="fas fa-birthday-cake"></i> Дата рождения') ?>
                    <?= $form->field($model, 'gender')->dropDownList([
                        '' => 'Выберите пол',
                        'Мужской' => 'Мужской',
                        'Женский' => 'Женский'
                    ])->label('<i class="fas fa-venus-mars"></i> Пол') ?>
                    <?= $form->field($model, 'citizenship')->textInput(['maxlength'=>true])->label('<i class="fas fa-globe"></i> Гражданство') ?>
                </div>
            </div>

            <div class="form-section">
                <h3 class="section-title"><i class="fas fa-passport"></i> Паспортные данные</h3>
                <div class="form-grid">
                    <?= $form->field($model, 'passport_series')->textInput(['maxlength'=>10])->label('<i class="fas fa-id-card"></i> Серия паспорта') ?>
                    <?= $form->field($model, 'passport_number')->textInput(['maxlength'=>20])->label('<i class="fas fa-id-card"></i> Номер паспорта') ?>
                    <?= $form->field($model, 'passport_issued_by')->textInput(['maxlength'=>255])->label('<i class="fas fa-building"></i> Кем выдан') ?>
                    <?= $form->field($model, 'passport_issue_date')->input('date')->label('<i class="fas fa-calendar-alt"></i> Дата выдачи') ?>
                    <?= $form->field($model, 'registration_address')->textInput(['maxlength'=>255])->label('<i class="fas fa-map-marker-alt"></i> Адрес регистрации') ?>
                </div>
            </div>

            <div class="form-section">
                <h3 class="section-title"><i class="fas fa-graduation-cap"></i> Образование</h3>
                <div class="form-grid">
                    <?= $form->field($model, 'education_level')->textInput(['maxlength'=>100])->label('<i class="fas fa-graduation-cap"></i> Уровень образования') ?>
                    <?= $form->field($model, 'education_institution')->textInput(['maxlength'=>255])->label('<i class="fas fa-university"></i> Учебное заведение') ?>
                    <?= $form->field($model, 'specialty')->textInput(['maxlength'=>255])->label('<i class="fas fa-book"></i> Специальность') ?>
                    <?= $form->field($model, 'diploma_series')->textInput(['maxlength'=>50])->label('<i class="fas fa-file-alt"></i> Серия диплома') ?>
                    <?= $form->field($model, 'diploma_number')->textInput(['maxlength'=>50])->label('<i class="fas fa-file-alt"></i> Номер диплома') ?>
                    <?= $form->field($model, 'diploma_file')->fileInput(['class' => 'form-control-file'])->label('<i class="fas fa-file-upload"></i> Файл диплома') ?>
                    <div class="file-hint"><i class="fas fa-info-circle"></i> Загрузите скан диплома</div>
                </div>
            </div>

            <div class="form-section">
                <h3 class="section-title"><i class="fas fa-briefcase"></i> Работа и документы</h3>
                <div class="form-grid">
                    <?= $form->field($model, 'snils')->textInput(['maxlength'=>20])->label('<i class="fas fa-id-card"></i> СНИЛС') ?>
                    <?= $form->field($model, 'snils_file')->fileInput(['class' => 'form-control-file'])->label('<i class="fas fa-file-upload"></i> Файл СНИЛС') ?>
                    <div class="file-hint"><i class="fas fa-info-circle"></i> Загрузите скан СНИЛС</div>
                    <?= $form->field($model, 'workplace')->textInput(['maxlength'=>255])->label('<i class="fas fa-building"></i> Место работы') ?>
                    <?= $form->field($model, 'position')->textInput(['maxlength'=>255])->label('<i class="fas fa-user-tie"></i> Должность') ?>
                    <?= $form->field($model, 'work_experience')->textInput()->label('<i class="fas fa-chart-line"></i> Стаж работы (лет)') ?>
                </div>
            </div>

            <div class="form-section">
                <h3 class="section-title"><i class="fas fa-heart"></i> Дополнительная информация</h3>
                <div class="form-grid">
                    <?= $form->field($model, 'marital_status')->textInput(['maxlength'=>100])->label('<i class="fas fa-heart"></i> Семейное положение') ?>
                    <?= $form->field($model, 'health_status')->textInput(['maxlength'=>255])->label('<i class="fas fa-heartbeat"></i> Состояние здоровья') ?>
                    <?= $form->field($model, 'email')->input('email')->label('<i class="fas fa-envelope"></i> Email') ?>
                    <?= $form->field($model, 'phone')->textInput(['maxlength'=>20])->label('<i class="fas fa-phone"></i> Телефон') ?>
                    <?= $form->field($model, 'photo')->fileInput(['class' => 'form-control-file'])->label('<i class="fas fa-camera"></i> Фото профиля') ?>
                    <div class="file-hint"><i class="fas fa-info-circle"></i> Загрузите ваше фото</div>
                </div>
                <?= $form->field($model, 'additional_info')->textarea(['rows' => 4])->label('<i class="fas fa-info-circle"></i> Дополнительная информация') ?>
            </div>

            <div class="form-actions">
                <?= Html::submitButton('<i class="fas fa-save"></i> Сохранить изменения', ['class'=>'btn btn-vibe btn-lg']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>