<?php
/** @var yii\web\View $this */
/** @var app\models\User $user */
/** @var app\models\Profile $profile */

use yii\helpers\Html;

$this->title = 'Мой профиль';
?>
<style>
    :root {
        --primary: #2c2c2c;
        --secondary: #515151;
        --accent: #fd79a8;
        --dark: #2d3436;
        --light: #dfe6e9;
        --success: #00b894;
        --warning: #fdcb6e;
        --danger: #e17055;
    }

    body {

        min-height: 100vh;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .profile-container {
        max-width: 1200px;
        margin: 0 auto;
    }

    .profile-header {
        background: linear-gradient(45deg, var(--primary), var(--secondary));
        color: white;
        border-radius: 15px;
        padding: 25px;
        margin-bottom: 25px;
        box-shadow: 0 10px 20px rgba(112, 112, 112, 0.2);
        position: relative;
        overflow: hidden;
    }

    .profile-header::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.1);
        transform: rotate(30deg);
    }

    .profile-card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        margin-bottom: 25px;
        overflow: hidden;
        transition: transform 0.3s ease;
    }

    .profile-card:hover {
        transform: translateY(-5px);
    }

    .profile-card-header {
        background: linear-gradient(45deg, var(--dark), #4a4a4a);
        color: white;
        padding: 15px 20px;
        font-weight: 600;
    }

    .profile-photo {
        width: 180px;
        height: 180px;
        border-radius: 50%;
        object-fit: cover;
        border: 5px solid white;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 15px;
    }

    .info-item {
        padding: 12px 15px;
        border-radius: 10px;
        background: #f8f9fa;
        transition: all 0.3s ease;
    }

    .info-item:hover {
        background: #e9ecef;
        transform: translateX(5px);
    }

    .info-label {
        font-weight: 600;
        color: var(--dark);
        margin-bottom: 5px;
        display: flex;
        align-items: center;
    }

    .info-label i {
        margin-right: 8px;
        color: var(--primary);
    }

    .info-value {
        color: #555;
    }

    .btn-vibe {
        background: linear-gradient(45deg, var(--primary), var(--secondary));
        color: white;
        border: none;
        border-radius: 50px;
        padding: 10px 25px;
        font-weight: 600;
        transition: all 0.3s ease;
        box-shadow: 0 5px 15px rgba(113, 113, 113, 0.3);
    }

    .btn-vibe:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(101, 101, 101, 0.4);
        color: white;
    }

    .section-title {
        position: relative;
        padding-bottom: 10px;
        margin-bottom: 20px;
        color: var(--dark);
    }

    .section-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 50px;
        height: 3px;
        background: var(--primary);
        border-radius: 3px;
    }

    .alert-vibe {
        border-radius: 10px;
        border: none;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .badge-vibe {
        background: linear-gradient(45deg, var(--primary), var(--secondary));
        color: white;
        border-radius: 20px;
        padding: 5px 12px;
    }

    .floating-icon {
        position: absolute;
        top: 20px;
        right: 20px;
        font-size: 24px;
        color: rgba(255, 255, 255, 0.7);
    }

    @media (max-width: 768px) {
        .info-grid {
            grid-template-columns: 1fr;
        }

        .profile-photo {
            width: 140px;
            height: 140px;
        }
    }
</style>
</head>
<body>
<div class="profile-container py-4">


    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success alert-vibe mb-4">
            <div class="d-flex align-items-center">
                <i class="fas fa-check-circle me-2"></i>
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        </div>
    <?php endif; ?>

    <div class="profile-card">
        <div class="profile-card-header d-flex justify-content-between align-items-center">
            <span><i class="fas fa-id-card me-2"></i>Личные данные</span>
            <span class="badge badge-vibe">Основная информация</span>
        </div>
        <div class="card-body p-4">
            <div class="row">
                <div class="col-md-4 text-center mb-4">
                    <div class="mb-4">
                        <?php if ($profile && $profile->photo): ?>
                            <img src="<?= Yii::getAlias('@web/' . $profile->photo) ?>" class="profile-photo" alt="Фото профиля">
                        <?php else: ?>
                            <img src="https://via.placeholder.com/200x200?text=Фото" class="profile-photo" alt="Фото профиля">
                        <?php endif; ?>
                    </div>
                    <?= Html::a('<i class="fas fa-edit me-2"></i>Редактировать профиль', ['profile/edit'], ['class'=>'btn btn-vibe w-100']) ?>
                </div>
                <div class="col-md-8">
                    <h3 class="section-title">Основная информация</h3>
                    <div class="info-grid mb-4">
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-user"></i> ФИО</div>
                            <div class="info-value"><?= Html::encode($user->fio ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-envelope"></i> Email</div>
                            <div class="info-value"><?= Html::encode($user->email ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-phone"></i> Телефон</div>
                            <div class="info-value"><?= Html::encode($user->phone ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-map-marker-alt"></i> Адрес</div>
                            <div class="info-value"><?= Html::encode($profile->address ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-birthday-cake"></i> Дата рождения</div>
                            <div class="info-value"><?= Html::encode($profile->birth_date ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-venus-mars"></i> Пол</div>
                            <div class="info-value"><?= Html::encode($profile->gender ?? '-') ?></div>
                        </div>
                    </div>

                    <h3 class="section-title">Паспортные данные</h3>
                    <div class="info-grid mb-4">
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-passport"></i> Гражданство</div>
                            <div class="info-value"><?= Html::encode($profile->citizenship ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-id-card"></i> Серия паспорта</div>
                            <div class="info-value"><?= Html::encode($profile->passport_series ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-id-card"></i> Номер паспорта</div>
                            <div class="info-value"><?= Html::encode($profile->passport_number ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-building"></i> Кем выдан</div>
                            <div class="info-value"><?= Html::encode($profile->passport_issued_by ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-calendar-alt"></i> Дата выдачи паспорта</div>
                            <div class="info-value"><?= Html::encode($profile->passport_issue_date ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-home"></i> Адрес регистрации</div>
                            <div class="info-value"><?= Html::encode($profile->registration_address ?? '-') ?></div>
                        </div>
                    </div>

                    <h3 class="section-title">Образование</h3>
                    <div class="info-grid mb-4">
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-graduation-cap"></i> Уровень образования</div>
                            <div class="info-value"><?= Html::encode($profile->education_level ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-university"></i> Учебное заведение</div>
                            <div class="info-value"><?= Html::encode($profile->education_institution ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-book"></i> Специальность</div>
                            <div class="info-value"><?= Html::encode($profile->specialty ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-file-alt"></i> Серия диплома</div>
                            <div class="info-value"><?= Html::encode($profile->diploma_series ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-file-alt"></i> Номер диплома</div>
                            <div class="info-value"><?= Html::encode($profile->diploma_number ?? '-') ?></div>
                        </div>
                    </div>

                    <h3 class="section-title">Работа и здоровье</h3>
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-briefcase"></i> Место работы</div>
                            <div class="info-value"><?= Html::encode($profile->workplace ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-user-tie"></i> Должность</div>
                            <div class="info-value"><?= Html::encode($profile->position ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-chart-line"></i> Стаж работы</div>
                            <div class="info-value"><?= Html::encode($profile->work_experience ?? '-') ?> лет</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-heartbeat"></i> Состояние здоровья</div>
                            <div class="info-value"><?= Html::encode($profile->health_status ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-heart"></i> Семейное положение</div>
                            <div class="info-value"><?= Html::encode($profile->marital_status ?? '-') ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-id-card"></i> СНИЛС</div>
                            <div class="info-value"><?= Html::encode($profile->snils ?? '-') ?></div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-info-circle"></i> Дополнительная информация</div>
                            <div class="info-value"><?= Html::encode($profile->additional_info ?? '-') ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>