<?php
use yii\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Панель администратора';
?>
        <style>
            :root {
                --primary: #323232;
                --secondary: #575757;
                --accent: #fd79a8;
                --dark: #dfdfdf;
                --light: #dfe6e9;
                --success: #00b894;
                --warning: #fdcb6e;
                --danger: #e17055;
                --gradient: linear-gradient(135deg, #393939 0%, #1c1c1c 100%);
            }

            body {
                background: #f8f9fa;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                min-height: 100vh;
            }

            .admin-container {
                max-width: 100%;
                margin: 0 auto;
                padding: 20px;
            }

            .admin-header {
                background: var(--gradient);
                color: white;
                border-radius: 20px;
                padding: 30px;
                margin-bottom: 30px;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
                position: relative;
                overflow: hidden;
            }

            .admin-header::before {
                content: '';
                position: absolute;
                top: -50%;
                right: -50%;
                width: 200%;
                height: 200%;
                background: rgba(255, 255, 255, 0.1);
                transform: rotate(45deg);
            }

            .admin-header h1 {
                margin: 0;
                font-weight: 800;
                font-size: 2.5rem;
                position: relative;
                z-index: 2;
            }

            .admin-header p {
                margin: 10px 0 0 0;
                opacity: 0.9;
                font-size: 1.1rem;
                position: relative;
                z-index: 2;
            }

            .stats-cards {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
                gap: 20px;
                margin-bottom: 30px;
            }

            .stat-card {
                background: white;
                border-radius: 15px;
                padding: 25px;
                text-align: center;
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
                transition: all 0.3s ease;
                border-left: 4px solid var(--primary);
            }

            .stat-card:hover {
                transform: translateY(-5px);
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
            }

            .stat-number {
                font-size: 2.5rem;
                font-weight: 800;
                color: var(--primary);
                margin-bottom: 5px;
            }

            .stat-label {
                color: var(--dark);
                font-weight: 600;
                font-size: 0.9rem;
            }

            .filters-card {
                background: white;
                border-radius: 20px;
                padding: 30px;
                margin-bottom: 30px;
                box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
            }

            .filter-header {
                color: var(--dark);
                font-weight: 700;
                margin-bottom: 20px;
                display: flex;
                align-items: center;
                font-size: 1.2rem;
            }

            .filter-header i {
                margin-right: 10px;
                color: var(--primary);
            }

            .form-control {
                border: 2px solid #e9ecef;
                border-radius: 12px;
                padding: 12px 15px;
                font-size: 14px;
                transition: all 0.3s ease;
            }

            .form-control:focus {
                border-color: var(--primary);
                box-shadow: 0 0 0 0.2rem rgba(108, 92, 231, 0.15);
            }

            .btn-admin {
                background: linear-gradient(45deg, var(--primary), var(--secondary));
                color: white;
                border: none;
                border-radius: 12px;
                padding: 12px 25px;
                font-weight: 600;
                transition: all 0.3s ease;
                box-shadow: 0 5px 15px rgba(108, 92, 231, 0.3);
            }

            .btn-admin:hover {
                transform: translateY(-2px);
                box-shadow: 0 8px 20px rgba(108, 92, 231, 0.4);
                color: white;
            }

            .btn-reset {
                background: #6c757d;
                color: white;
                border: none;
                border-radius: 12px;
                padding: 12px 25px;
                font-weight: 600;
                transition: all 0.3s ease;
            }

            .btn-reset:hover {
                background: #5a6268;
                color: white;
                transform: translateY(-2px);
            }

            .grid-card {
                background: white;
                border-radius: 20px;
                padding: 30px;
                box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
                overflow: hidden;
            }

            .table {
                margin-bottom: 0;
            }

            .table thead th {
                background: #efefef;
                color: #131313;
                border: none;
                padding: 15px;
                font-weight: 600;
            }

            .table tbody td {
                padding: 15px;
                vertical-align: middle;
                border-color: #f1f3f4;
            }

            .table tbody tr {
                transition: all 0.3s ease;
            }

            .table tbody tr:hover {
                background: #f8f9fa;
                transform: scale(1.01);
            }

            .status-select {
                border: 2px solid #e9ecef;
                border-radius: 8px;
                padding: 8px 12px;
                font-size: 14px;
                background: white;
                transition: all 0.3s ease;
                min-width: 180px;
            }

            .status-select:focus {
                border-color: var(--primary);
                box-shadow: 0 0 0 0.2rem rgba(108, 92, 231, 0.15);
            }

            .status-new { background: #fff3cd; color: #856404; padding: 4px 8px; border-radius: 6px; font-size: 12px; font-weight: 600; }
            .status-processing { background: #cce7ff; color: #004085; padding: 4px 8px; border-radius: 6px; font-size: 12px; font-weight: 600; }
            .status-accepted { background: #d4edda; color: #155724; padding: 4px 8px; border-radius: 6px; font-size: 12px; font-weight: 600; }

            .action-btn {
                display: inline-flex;
                align-items: center;
                justify-content: center;
                width: 35px;
                height: 35px;
                border-radius: 8px;
                background: #f8f9fa;
                color: var(--dark);
                text-decoration: none;
                transition: all 0.3s ease;
                margin-right: 5px;
            }

            .action-btn:hover {
                background: var(--primary);
                color: white;
                transform: scale(1.1);
            }

            .pagination {
                margin-top: 20px;
            }

            .page-item.active .page-link {
                background: var(--primary);
                border-color: var(--primary);
            }

            .page-link {
                color: var(--primary);
                border-radius: 8px;
                margin: 0 3px;
                border: 1px solid #dee2e6;
            }

            .page-link:hover {
                color: var(--primary);
                background: #f8f9fa;
            }

            @media (max-width: 768px) {
                .admin-header {
                    padding: 20px;
                }

                .admin-header h1 {
                    font-size: 2rem;
                }

                .filters-card,
                .grid-card {
                    padding: 20px;
                }

                .stats-cards {
                    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
                }
            }
        </style>
    </head>
<body>
<div class="admin-container">
    <div class="admin-header">
        <h1><i class="fas fa-crown me-3"></i><?= Html::encode($this->title) ?></h1>
        <p>Управление анкетами сотрудников и системами</p>
    </div>

    <div class="stats-cards">
        <div class="stat-card">
            <div class="stat-number"><?= $dataProvider->getTotalCount() ?></div>
            <div class="stat-label">Всего анкет</div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?= $dataProvider->getTotalCount() ?></div>
            <div class="stat-label">На проверке</div>
        </div>
        <div class="stat-card">
            <div class="stat-number">0</div>
            <div class="stat-label">Принято</div>
        </div>
        <div class="stat-card">
            <div class="stat-number">0</div>
            <div class="stat-label">Отклонено</div>
        </div>
    </div>

    <div class="filters-card">
        <div class="filter-header">
            <i class="fas fa-filter"></i> Фильтры и поиск
        </div>
        <?php $form = ActiveForm::begin([
            'method'=>'get',
            'action'=>['admin/index'],
            'options' => ['class' => 'filters-form']
        ]); ?>
        <div class="row g-3">
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['gender'=>$filters['gender'] ?? null]), 'gender')
                    ->dropDownList([
                        ''=>'Все',
                        'Мужской'=>'Мужской',
                        'Женский'=>'Женский',
                        'Другой'=>'Другой'
                    ], ['class' => 'form-control'])->label('Пол') ?>
            </div>
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['education_level'=>$filters['education_level'] ?? null]), 'education_level')
                    ->textInput(['class' => 'form-control', 'placeholder' => 'Уровень образования'])->label('Образование') ?>
            </div>
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['position'=>$filters['position'] ?? null]), 'position')
                    ->textInput(['class' => 'form-control', 'placeholder' => 'Должность'])->label('Должность') ?>
            </div>
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['minExp'=>$filters['minExp'] ?? null]), 'minExp')
                    ->input('number', ['class' => 'form-control', 'placeholder' => 'Мин. стаж'])->label('Стаж от') ?>
            </div>
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['maxExp'=>$filters['maxExp'] ?? null]), 'maxExp')
                    ->input('number', ['class' => 'form-control', 'placeholder' => 'Макс. стаж'])->label('Стаж до') ?>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <?= Html::submitButton('<i class="fas fa-search me-2"></i>Фильтровать', ['class'=>'btn btn-admin w-100 me-2']) ?>
                <?= Html::a('<i class="fas fa-redo me-2"></i>Сбросить', ['admin/index'], ['class'=>'btn btn-reset w-100']) ?>
            </div>
        </div>
        <?php ActiveForm::end(); ?>
    </div>

    <div class="grid-card">
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'tableOptions' => ['class' => 'table table-hover'],
            'options' => ['class' => 'grid-view'],
            'columns' => [
                [
                    'class' => 'yii\grid\SerialColumn',
                    'header' => '#',
                    'contentOptions' => ['style' => 'font-weight: 600; color: var(--primary);']
                ],
                [
                    'attribute' => 'user_id',
                    'label' => 'ФИО',
                    'value' => function($m){ return $m->user->fio ?? '-'; },
                    'contentOptions' => ['style' => 'font-weight: 500;']
                ],
                [
                    'attribute' => 'position',
                    'contentOptions' => ['style' => 'max-width: 200px;']
                ],
                [
                    'attribute' => 'additional_info',
                    'contentOptions' => ['style' => 'max-width: 250px;'],
                    'value' => function($m){
                        return strlen($m->additional_info) > 50 ?
                            substr($m->additional_info, 0, 50) . '...' :
                            $m->additional_info;
                    }
                ],
                [
                    'attribute' => 'status',
                    'contentOptions' => function($model) {
                        $class = 'status-new';
                        if ($model->status == 'Идет проверка данных') $class = 'status-processing';
                        if ($model->status == 'Данные приняты') $class = 'status-accepted';
                        return ['class' => $class];
                    }
                ],
                [
                    'attribute' => 'created_at',
                    'format' => 'datetime',
                    'contentOptions' => ['style' => 'white-space: nowrap;']
                ],
                [
                    'class' => 'yii\grid\ActionColumn',
                    'template' => '{view} {status}',
                    'header' => 'Действия',
                    'contentOptions' => ['style' => 'white-space: nowrap;'],
                    'buttons' => [
                        'view' => function($url, $model, $key) {
                            return Html::a('<i class="fas fa-eye"></i>', $url, [
                                'class' => 'action-btn',
                                'title' => 'Просмотр',
                                'data-bs-toggle' => 'tooltip'
                            ]);
                        },
                        'status' => function($url, $model, $key) {
                            $drop = Html::dropDownList("status_{$model->id}", $model->status, [
                                'Новая' => 'Новая',
                                'Идет проверка данных' => 'Идет проверка данных',
                                'Данные приняты' => 'Данные приняты'
                            ], [
                                'class' => 'status-select',
                                'data-id' => $model->id,
                                'data-bs-toggle' => 'tooltip',
                                'title' => 'Изменить статус'
                            ]);
                            return $drop;
                        }
                    ]
                ],
            ],
            'pager' => [
                'options' => ['class' => 'pagination justify-content-center'],
                'linkContainerOptions' => ['class' => 'page-item'],
                'linkOptions' => ['class' => 'page-link'],
            ]
        ]); ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<?php
$changeUrl = Url::to(['admin/change-status']);
$js = <<<JS
    // Инициализация тултипов
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    });
    
    $('.status-select').on('change', function(){
        var id = $(this).data('id');
        var status = $(this).val();
        var select = $(this);
        
        select.prop('disabled', true);
        
        $.post('$changeUrl', {id: id, status: status}, function(res){
            if(res.success){
                // Анимация успешного изменения
                select.closest('tr').css('background', '#d4edda');
                setTimeout(function(){
                    select.closest('tr').css('background', '');
                }, 1000);
                
                // Обновляем статус в таблице
                var statusCell = select.closest('td').prev().prev();
                statusCell.removeClass('status-new status-processing status-accepted');
                if(status == 'Новая') statusCell.addClass('status-new');
                if(status == 'Идет проверка данных') statusCell.addClass('status-processing');
                if(status == 'Данные приняты') statusCell.addClass('status-accepted');
                statusCell.text(status);
                
            } else {
                alert('Ошибка: ' + res.message);
            }
            select.prop('disabled', false);
        }, 'json').fail(function(){
            alert('Ошибка сети');
            select.prop('disabled', false);
        });
    });
    JS;
$this->registerJs($js);
?>