<?php
namespace app\models;

use yii\db\ActiveRecord;

class EmployeeProfile extends ActiveRecord
{
    public static function tableName()
    {
        return '{{%employee_profile}}';
    }

    public function rules()
    {
        return [
            [['user_id'], 'required'],
            [['birth_date', 'passport_issued_date', 'created_at', 'updated_at'], 'safe'],
            [['registration_address', 'health_status', 'additional_info'], 'string'],
            [['work_experience_years'], 'integer'],
            [['status'], 'default', 'value' => 'Новая'],
            [['status'], 'in', 'range' => ['Новая', 'Идет проверка данных', 'Данные приняты']],
        ];
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getDocuments()
    {
        return $this->hasMany(Document::class, ['profile_id' => 'id']);
    }
}