<?php
namespace app\models;

use yii\db\ActiveRecord;

class Document extends ActiveRecord
{
    public static function tableName()
    {
        return '{{%document}}';
    }

    public function rules()
    {
        return [
            [['profile_id', 'doc_type', 'file_path'], 'required'],
            [['file_size'], 'integer'],
            [['uploaded_at'], 'safe'],
        ];
    }

    public function getProfile()
    {
        return $this->hasOne(EmployeeProfile::class, ['id' => 'profile_id']);
    }
}