<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%file}}`.
 */
class m251112_121425_create_file_table extends Migration
{
    public function safeUp()
    {
        $this->createTable('{{%file}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'profile_id' => $this->integer(),
            'file_name' => $this->string(255),
            'file_path' => $this->string(255),
            'file_type' => $this->string(50),
            'file_size' => $this->integer(),
            'uploaded_at' => $this->integer(),
        ]);

        $this->addForeignKey('fk-file-user_id', '{{%file}}', 'user_id', '{{%user}}', 'id', 'CASCADE');
    }

    public function safeDown()
    {
        $this->dropForeignKey('fk-file-user_id', '{{%file}}');
        $this->dropTable('{{%file}}');
    }
}