<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Profile;
use app\models\User;
use yii\data\ActiveDataProvider;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * AdminController — панель администратора
 */
class AdminController extends Controller
{
    public function behaviors()
    {
        return [
            'access'=>[
                'class'=>AccessControl::class,
                'only'=>['index','view','change-status'],
                'rules'=>[
                    [
                        'allow'=>true,
                        'roles'=>['@'],
                        'matchCallback'=>function($rule, $action) {
                            return \Yii::$app->user->identity->role === 'admin';
                        }
                    ],
                ],
            ],
            'verbs'=>[
                'class'=>VerbFilter::class,
                'actions'=>[
                    'change-status'=>['POST'],
                ],
            ],
        ];
    }

    /**
     * Список анкет с фильтрами
     */
    public function actionIndex()
    {
        $query = Profile::find()->with('user');

        // фильтрация по GET-параметрам
        $get = Yii::$app->request->get();

        if (!empty($get['gender'])) {
            $query->andWhere(['gender' => $get['gender']]);
        }
        if (!empty($get['citizenship'])) {
            $query->andWhere(['citizenship' => $get['citizenship']]);
        }
        if (!empty($get['education_level'])) {
            $query->andWhere(['education_level' => $get['education_level']]);
        }
        if (!empty($get['position'])) {
            $query->andWhere(['like', 'position', $get['position']]);
        }
        if (!empty($get['marital_status'])) {
            $query->andWhere(['marital_status' => $get['marital_status']]);
        }
        if (!empty($get['minExp'])) {
            $query->andWhere(['>=', 'work_experience', (int)$get['minExp']]);
        }
        if (!empty($get['maxExp'])) {
            $query->andWhere(['<=', 'work_experience', (int)$get['maxExp']]);
        }

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => ['pageSize' => 20],
            'sort' => [
                'defaultOrder' => ['created_at' => SORT_DESC],
                'attributes' => ['created_at','status','work_experience','position']
            ]
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'filters' => $get,
        ]);
    }

    /**
     * Просмотр анкеты (по id)
     */
    public function actionView($id)
    {
        $model = Profile::findOne($id);
        if (!$model) {
            throw new NotFoundHttpException('Анкета не найдена');
        }
        return $this->render('view', ['model' => $model]);
    }

    /**
     * Смена статуса анкеты (POST) — ожидает profile_id и status
     */
    public function actionChangeStatus()
    {
        $id = Yii::$app->request->post('id');
        $status = Yii::$app->request->post('status');
        $model = Profile::findOne($id);
        if (!$model) {
            return $this->asJson(['success' => false, 'message' => 'Анкета не найдена']);
        }
        $allowed = ['Новая', 'Идет проверка данных', 'Данные приняты'];
        if (!in_array($status, $allowed, true)) {
            return $this->asJson(['success' => false, 'message' => 'Недопустимый статус']);
        }
        $model->status = $status;
        if ($model->save(false)) {
            return $this->asJson(['success' => true, 'status' => $model->status]);
        }
        return $this->asJson(['success' => false, 'message' => 'Не удалось изменить статус']);
    }
}
